//C3D_VERSINO_REQUIREMENT 7.0.0
//
// Boolean Cut.js
//
// 2016-11-30: initial release.
//
// Hiroto Tsubaki tg@tres-graficos.jp
//

function buildUI( tool ) {
	tool.addParameterSeparator("Booelan Cut");
	
	tool.addParameterLink("cut spline", false);
	
	//tool.addParameterSelector("cut direction", ["x", "y", "z"], false, false);
	
	tool.addParameterBool("keep original", 1, 0, 1, false, false);

	tool.addParameterButton("cut", "apply", "cutSpline");

}

function cutSpline( tool ) {
	var doc = tool.document();
	var obj = doc.selectedObject();
	var spline = tool.getParameter("cut spline");
	
	var keep = tool.getParameter("keep original");
	var group = true; //tool.getParameter("make group");

	//print('-- cutSpline');

	if (!obj || !spline) {
		OS.beep(); return;
	}
	
	if (obj.family() == NGONFAMILY && spline.family() == SPLINEFAMILY) {
		var i, j, k;
				
		var dir = 2; //tool.getParameter("cut direction");
		
		// detect cage

		var maxSize = sizeMax( obj, 1 );

		//

		var objName = obj.getParameter("name");
		var objMat = obj.obj2WorldMatrix();
		var objMatInverse = objMat.inverse();
		
		var splineCore = spline.core();

		var splineTr = spline.getParameter("position");
		var splineRot = spline.getParameter("rotation");
		var splineScale = spline.getParameter("scale");
		var splineObjMat = spline.obj2WorldMatrix();

		var dis = Vec3D_distance( new Vec3D( objMat.m03, objMat.m13, objMat.m23 ), new Vec3D( splineObjMat.m03, splineObjMat.m13, splineObjMat.m23 ) );
		maxSize += dis * 3;

		var dirVec;
		var thickVec;
		switch( parseInt(dir) ) {
			case 0: // -x
				dirVec = new Vec3D( -1, 0, 0 );
				thickVec = new Vec3D( 0, 0, 1 );

				splineTr.y = 0;
				splineTr.z = 0;
				break;
			case 1: // -y
				dirVec = new Vec3D( 0, -1, 0 );
				thickVec = new Vec3D( 1, 0, 0 );

				splineTr.x = 0;
				splineTr.z = 0;
				break;
			case 2: // -z
				dirVec = new Vec3D( 0, 0, -1 );
				thickVec = new Vec3D( 0, 1, 0 );

				splineTr.x = 0;
				splineTr.y = 0;
				break;
		}

		//
		var splineTraMat = new Mat4D( TRANSLATE, splineTr.x * -1, splineTr.y * -1, splineTr.z * -1 );
		var splineRotMat = new Mat4D( ROTATE_HPB, splineRot.x, splineRot.y, splineRot.z );
		var splineScaleMat = new Mat4D( SCALE, splineScale.x, splineScale.y, splineScale.z );

		var splineMat = spline.obj2WorldMatrix(); //splineTraMat.multiply( spline.obj2WorldMatrix() );

		// spline vector		
		dirVec = dirVec.multiply( maxSize );
		thickVec = thickVec.multiply( maxSize );

		var objCut = doc.addObject(POLYGONOBJ);
		var coreCut = objCut.core();

		var cutMat = objMatInverse.multiply( splineMat ); //splineScaleMat.multiply( splineRotMat ) );

		coreCut.buildVertexBSP(new Vec3D(maxSize * -1, maxSize * -1, maxSize * -1), new Vec3D(maxSize, maxSize, maxSize));

		var pathCount = splineCore.pathCount();
		for (i = 0;i < pathCount;i++) {
			var pathInfo = splineCore.cache(i);
			var pathLen = pathInfo.length;

			// check closed path
			var closed = (pathInfo[0].isEqual( pathInfo[pathLen-1] ))? true : false;

			var vecs, vecs_cover1, vecs_cover2;
			for (j = 1;j < pathLen;j++) {
				vecs = [ pathInfo[j-1].add( dirVec ), 
						 pathInfo[j].add( dirVec ), 
						 pathInfo[j].sub( dirVec ), 
						 pathInfo[j-1].sub( dirVec )
					    ];


				if (closed) { // closed path
					coreCut.addPolygon(4, true, vecs.map( function( obj ) { return cutMat.multiply( obj ) } ));

					if (j == 1) {
						var covers = [];

						for (k = 0;k < pathLen-1;k++) {
							covers[k] = cutMat.multiply( pathInfo[k].add( dirVec ) );
						}
						coreCut.addPolygon( covers.length, true, covers.reverse() );

						covers = [];
						for (k = 0;k < pathLen-1;k++) {
							covers[k] = cutMat.multiply( pathInfo[k].sub( dirVec ) );
						}
						coreCut.addPolygon(covers.length, true, covers);
					}
				} else { // open path
					vecs = vecs.reverse();

					coreCut.addPolygon(4, true, vecs.map( function( obj ) { return cutMat.multiply( obj ) } ));
					coreCut.addPolygon(4, true, vecs.map( function( obj ) { return cutMat.multiply( obj.add(thickVec) ) } ).reverse() );
					
					vecs_cover1 = [ vecs[0], vecs[1], vecs[1].add( thickVec ), vecs[0].add( thickVec ) ];
					coreCut.addPolygon(4, true, vecs_cover1.map( function( obj ) { return cutMat.multiply( obj ) } ).reverse());
					vecs_cover2 = [ vecs[3], vecs[2], vecs[2].add( thickVec ), vecs[3].add( thickVec ) ];
					coreCut.addPolygon(4, true, vecs_cover2.map( function( obj ) { return cutMat.multiply( obj ) } ));
					if (j == 1) {
						coreCut.addPolygon(4, true, [ vecs_cover1[0], vecs_cover1[3], vecs_cover2[3], vecs_cover2[0] ].map( function( obj ) { return cutMat.multiply( obj ) } ).reverse());
					}
					if (j == pathLen - 1) {
						coreCut.addPolygon(4, true, [ vecs_cover1[1], vecs_cover1[2], vecs_cover2[2], vecs_cover2[1] ].map( function( obj ) { return cutMat.multiply( obj ) } ));
					}
				}
			}
		}

		coreCut.destroyVertexBSP();

		objCut.update();

		doc.selectObject( obj, false );

		var booleanMod = doc.addObject(BOOLEANMOD);

		booleanMod.addChildAtIndex(objCut, 0);

		booleanMod.setParameter("operation", 1);

		var objOp1 = doc.addObject(POLYGONOBJ);
		doc.root().addChildAtIndex(objOp1, doc.root().childCount() - 1);

		copyPolygons(obj.modCore(), objOp1.core());

		var op1Res = centerPivot(objOp1);

		if (op1Res) {
			objOp1.setParameter("name", objName + '_parts');
			objOp1.update();
		} else {
			doc.root().removeChild( objOp1 );
			objOp1 = null;
		}

		booleanMod.setParameter("operation", 2);

		var objOp2 = doc.addObject(POLYGONOBJ);
		doc.root().addChildAtIndex(objOp2, doc.root().childCount() - 1);

		copyPolygons(obj.modCore(), objOp2.core());

		var op2Res = centerPivot(objOp2);

		if (op2Res) {
			objOp2.setParameter("name", objName + '_parts');
			objOp2.update();
		} else {
			doc.root().removeChild( objOp2 );
			objOp2 = null;
		}

		obj.removeChild( booleanMod );

		if (keep) {
			obj.update();
		} else {
			obj.owner().removeChild( obj );
		}

		//group cut objects

		{
			var folder = doc.addObject(FOLDER);
			doc.root().addChildAtIndex(folder, doc.root().childCount() - 1);

			if ( objOp1 !== null) folder.addChildAtIndex(objOp1, 0);
			if ( objOp2 !== null) folder.addChildAtIndex(objOp2, 1);

			folder.setParameter("name", objName + '_cut');
			copyParameters(obj, folder, ["position", "rotation", "scale"]);
		}
	}
}

function copyParameters(from, to, params) {
	for (i in params) {
		to.setParameter(params[i], from.getParameter(params[i]));
	}
}

function copyPolygons(from, to) {

	var vertexCount = from.vertexCount();

	for (i = 0;i < vertexCount;i++) {
		to.addVertex(false, from.vertex(i));
	}

	var polygonCount = from.polygonCount();

	for (i = 0;i < polygonCount;i++) {
		var polygonSize = from.polygonSize(i);
		var verts = [];
		var uvs = [];
		for (j = 0;j < polygonSize;j++) {
			verts.push( from.vertexIndex(i, j) );
			uvs.push( from.uvCoord(i, j) );
		}

		to.addIndexPolygon(polygonSize, verts, uvs);
	}
}

function centerPivot(obj) {
	var core = obj.core();
	var vertexCount = core.vertexCount();

	if ( vertexCount < 1) return false;

	var centerVec;
	for (i = 0;i < vertexCount;i++) {
		if (i == 0) {
			centerVec = core.vertex(i);
		} else {
			centerVec = centerVec.add( core.vertex(i) );
		}
	}

	centerVec = centerVec.multiply( 1 / vertexCount );

	for (i = 0;i < vertexCount;i++) {
		core.setVertex( i, core.vertex(i).sub(centerVec) );
	}

	obj.setParameter("position", obj.getParameter("position").add(centerVec));

	return true;
}

function sizeMax(obj, margin) {
	var sizeMax = 1;

	var core = obj.core();
	var mat = obj.obj2WorldMatrix();
	var vertexCount = core.vertexCount();

	for (i = 0;i < vertexCount;i++) {
		var vec = mat.multiply( core.vertex(i) );

		if (Math.abs(vec.x) > sizeMax) sizeMax = Math.abs(vec.x);
		if (Math.abs(vec.y) > sizeMax) sizeMax = Math.abs(vec.y);
		if (Math.abs(vec.z) > sizeMax) sizeMax = Math.abs(vec.z);
	}

	return sizeMax + margin;
}

var multiplyMat = function( obj, mat ) {
	print( 'mat:' + mat );
	return mat.multiply( obj );
}

var Vec3D_distance = function() {
	if( arguments.length == 1)
			return Math.sqrt( arguments[0].x*arguments[0].x + arguments[0].y*arguments[0].y + arguments[0].z*arguments[0].z );
	var p = arguments[1].sub(arguments[0]);
	return Math.sqrt( p.x*p.x + p.y*p.y + p.z*p.z );
}

var Vec3D_normalize = function(vec) {
	var l = vec.norm();
	if (l != 0) {
		return vec.multiply( 1/l );
	}
	return vec;
}